import {
  Carousel,
  CreateCarousel,
  CarouselPaginator,
  QueryOptions,
  GetParams,
  CarouselQueryOptions,
} from '@/types';
import { API_ENDPOINTS } from './api-endpoints';
import { crudFactory } from './curd-factory';
import { HttpClient } from './http-client';

export const carouselClient = {
  ...crudFactory<Carousel, QueryOptions, CreateCarousel>(
    API_ENDPOINTS.CAROUSELS
  ),
  get({ slug, language }: GetParams) {
    return HttpClient.get<Carousel>(`${API_ENDPOINTS.CAROUSELS}/${slug}`, {
      language,
      with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
    });
  },
  // delete({ slug, language }: GetParams) {
  //   return HttpClient.get<Carousel>(
  //     `${API_ENDPOINTS.CAROUSELS}/delete/${slug}`,
  //     {
  //       language,
  //       with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
  //     }
  //   );
  // },
  paginated: ({ ...params }: Partial<CarouselQueryOptions>) => {
    return HttpClient.get<CarouselPaginator>(API_ENDPOINTS.CAROUSELS, {
      searchJoin: 'and',
      with: 'shop;type',
      ...params,
    });
  },
  popular({ ...params }: Partial<CarouselQueryOptions>) {
    return HttpClient.get<Carousel[]>(API_ENDPOINTS.POPULAR_PRODUCTS, {
      searchJoin: 'and',
      with: 'type;shop',
      ...params,
    });
  },
};
