import {
  CreateMenuInput,
  Menu,
  MenuPaginator,
  MenuQueryOptions,
  QueryOptions,
} from '@/types';
import { API_ENDPOINTS } from './api-endpoints';
import { crudFactory } from './curd-factory';
import { HttpClient } from './http-client';

export const menuClient = {
  ...crudFactory<Menu, QueryOptions, CreateMenuInput>(API_ENDPOINTS.MENUS),
  paginated: ({ title, ...params }: Partial<MenuQueryOptions>) => {
    return HttpClient.get<MenuPaginator>(API_ENDPOINTS.MENUS, {
      searchJoin: 'and',
      ...params,
      search: HttpClient.formatSearchParams({ title }),
    });
  },
};
