import {
  Section,
  CreateSection,
  QueryOptions,
  SectionQueryOptions,
  GetParams,
  SectionPaginator,
} from '@/types';
import { API_ENDPOINTS } from './api-endpoints';
import { crudFactory } from './curd-factory';
import { HttpClient } from './http-client';

export const SectionClient = {
  ...crudFactory<Section, QueryOptions, CreateSection>(API_ENDPOINTS.SECTION),
  get({ slug, language }: GetParams) {
    return HttpClient.get<Section>(`${API_ENDPOINTS.SECTION}/${slug}`, {
      language,
      with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
    });
  },
  paginated: ({ ...params }: Partial<SectionQueryOptions>) => {
    return HttpClient.get<SectionPaginator>(API_ENDPOINTS.SECTION, {
      searchJoin: 'and',
      with: 'shop;type',
      ...params,
    });
  },
  popular({ ...params }: Partial<SectionQueryOptions>) {
    return HttpClient.get<Section[]>(API_ENDPOINTS.SECTION, {
      searchJoin: 'and',
      with: 'type;shop',
      ...params,
    });
  },
};
