import {
  QueryOptions,
  GetParams,
  CarouselQueryOptions,
  ShippingAddress,
  CreateShippingAddress,
  ShippingAddressPaginator,
  ShippingAddressQueryOptions,
} from '@/types';
import { API_ENDPOINTS } from './api-endpoints';
import { crudFactory } from './curd-factory';
import { HttpClient } from './http-client';

export const shippingAddressClient = {
  ...crudFactory<ShippingAddress, QueryOptions, CreateShippingAddress>(
    API_ENDPOINTS.SHIPPING_ADDRESS
  ),
  get({ slug, language }: GetParams) {
    return HttpClient.get<ShippingAddress>(
      `${API_ENDPOINTS.SHIPPING_ADDRESS}/${slug}`,
      {
        language,
        with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
      }
    );
  },
  // delete({ slug, language }: GetParams) {
  //   return HttpClient.get<Carousel>(
  //     `${API_ENDPOINTS.CAROUSELS}/delete/${slug}`,
  //     {
  //       language,
  //       with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
  //     }
  //   );
  // },
  paginated: ({ ...params }: Partial<CarouselQueryOptions>) => {
    return HttpClient.get<ShippingAddressPaginator>(
      API_ENDPOINTS.SHIPPING_ADDRESS,
      {
        searchJoin: 'and',
        with: 'shop;type',
        ...params,
      }
    );
  },
  popular({ ...params }: Partial<ShippingAddressQueryOptions>) {
    return HttpClient.get<ShippingAddress[]>(API_ENDPOINTS.POPULAR_PRODUCTS, {
      searchJoin: 'and',
      with: 'type;shop',
      ...params,
    });
  },
};
