import {
  SixAdBanner,
  CreateSixAdBanner,
  SixAdBannerPaginator,
  QueryOptions,
  GetParams,
  SixAdBannerQueryOptions,
} from '@/types';
import { API_ENDPOINTS } from './api-endpoints';
import { crudFactory } from './curd-factory';
import { HttpClient } from './http-client';

export const sixAdBannerClient = {
  ...crudFactory<SixAdBanner, QueryOptions, CreateSixAdBanner>(
    API_ENDPOINTS.SIXADBANNERS
  ),
  get({ slug, language }: GetParams) {
    return HttpClient.get<SixAdBanner>(
      `${API_ENDPOINTS.SIXADBANNERS}/${slug}`,
      {
        language,
        with: 'type;shop;categories;tags;variations.attribute.values;variation_options;author;manufacturer;digital_file',
      }
    );
  },
  paginated: ({ ...params }: Partial<SixAdBannerQueryOptions>) => {
    return HttpClient.get<SixAdBannerPaginator>(API_ENDPOINTS.SIXADBANNERS, {
      searchJoin: 'and',
      with: 'shop;type',
      ...params,
    });
  },
  popular({ ...params }: Partial<SixAdBannerQueryOptions>) {
    return HttpClient.get<SixAdBanner[]>(API_ENDPOINTS.POPULAR_PRODUCTS, {
      searchJoin: 'and',
      with: 'type;shop',
      ...params,
    });
  },
};
