import Layout from '@/components/layouts/admin';

import { serverSideTranslations } from 'next-i18next/serverSideTranslations';
import { useTranslation } from 'next-i18next';
import CreateOrUpdateCarouselsForm from '@/components/carousel/carousel-form';
import ShippingAddressForm from '@/components/shipping-address/shipping-address-form';

export default function CreateCarouselsPage() {
  const { t } = useTranslation();
  return (
    <>
      <div className="flex border-b border-dashed border-border-base py-5 sm:py-8">
        <h1 className="text-lg font-semibold text-heading">Shipping Address</h1>
      </div>
      <ShippingAddressForm />
    </>
  );
}

CreateCarouselsPage.Layout = Layout;

export const getStaticProps = async ({ locale }: any) => ({
  props: {
    ...(await serverSideTranslations(locale, ['form', 'common'])),
  },
});
